;	===============================================================
;	DIALOG.CPY - Dialog box macros and definitions
;	===============================================================
;	Copyright 1999 Michael Riddle
;	All rights reserved
;	Written by Mike Riddle 1-9-99
;	===============================================================

PM_GETDATA	equ	WM_USER+1900	;get wParam bytes private data to *lParam
PM_SETDATA	equ	WM_USER+1901	;set wParam bytes private data from *lParam

Dialog		proto	stdcall,pDlgCtl:dword,hModHdl:dword,pBase:dword
InitDialogHelp	proto	stdcall,pCallback:dword,nMsg:dword

HideCtl 	proto	stdcall,nCtrl:dword
ShowCtl 	proto	stdcall,nCtrl:dword
DsAbCtl 	proto	stdcall,nCtrl:dword
EnAbCtl 	proto	stdcall,nCtrl:dword
FocusCtl 	proto	stdcall,nCtrl:dword
UpdCtlA 	proto	stdcall
UpdCtl		proto	stdcall,nCtrl:dword
SetCtlText	proto	stdcall,nCtrl:dword,pText:dword
SetDlgTitle	proto	stdcall,pText:dword
ClrLstStr	proto	stdcall,nCtrl:dword
AddLstStr	proto	stdcall,nCtrl:dword,pStg:dword
FndLstStr	proto	stdcall,nCtrl:dword,pStg:dword
GetLstStr	proto	stdcall,nCtrl:dword,pStg:dword
GetLstStrN	proto	stdcall,nCtrl:dword,nWant:dword,pStg:dword
SetLstData	proto	stdcall,nCtrl:dword,nItem:dword,iData:dword
GetLstData	proto	stdcall,nCtrl:dword,nItem:dword
ClrCmbStr	proto	stdcall,nCtrl:dword
AddCmbStr	proto	stdcall,nCtrl:dword,pStg:dword
FndCmbStr	proto	stdcall,nCtrl:dword,pStg:dword
GetCmbStr	proto	stdcall,nCtrl:dword,pStg:dword
SetCmbData	proto	stdcall,nCtrl:dword,nItem:dword,iData:dword
GetCmbData	proto	stdcall,nCtrl:dword,nItem:dword
GetDlgWin	proto	stdcall
GetDlgDig	proto	stdcall,id:dword,lppnt:dword
GetLstMSel	proto	stdcall,nCtrl:dword,pSel:dword,nMax:dword

;	===============================================================
;	The Dialog Control Table (pDlgCtl in Dialog call)
;	===============================================================
;
;	This table starts with a dialog box header (SDlg) structure,
;	followed by an ANSIZ dialog resource name,
;	followed by none or more control packet (DCtrl) structures,
;	ending with an ENDDLG macro (one word = 0).
;
;	---------------------------------------------------------------
;	Dialog box header
;	---------------------------------------------------------------

SDlg		struct
chain		dword	0		;offset of control data
Options 	dword	0		;dialog box options
HlpCntxt	dword	0		;Help context number
InitCF		dword	0		;WM_INITDIALOG callback
EndCF		dword	0		;WM_DESTROY callback
HlpFile 	dword	0		;optional custom help file
SDlg		ends

;	---------------------------------------------------------------
;	Dialog box control packet
;	---------------------------------------------------------------

DCtrl		struct
CType		word	0		;type
Id		word	0		;control Id
Flags		word	0
Options 	word	0
Wdth		dword	0
MaxVal		dword	0		;Max for Comm Ctrls
MinVal		dword	0		;Min for Comm Ctrls
Data1		dword	0		;data pointers
Data2		dword	0
CB1		dword	0		;callback functions
OwnerDraw	dword	0
DCtrl		ends

;	===============================================================
;	Definitions
;	===============================================================

;		Dialog Option flags

DO_PRBAR	equ	1
DO_MODELESS	equ	2

;		Control types

CT_EDIT 	equ	1
CT_CMB		equ	2
CT_CHK		equ	3
CT_LST		equ	4
CT_BTN		equ	5
CT_RB		equ	6
CT_BM		equ	7
CT_EDITUD	equ	8
CT_COLORPK	equ	9
CT_PATED	equ	10
CT_PB		equ	11
CT_PATED32	equ	12

UDCtl_Offset	equ	00010000h
TBCtl_Offset	equ	00020000h
PBCtl_Offset	equ	00030000h

;		Control Option flags

; callback after each key press in edit/combo box item
CO_CBOnKey	equ	1
; do not initially select text in edit item
CO_NoSel	equ	2
; Undetermined value - display grey check in check, blank edit field etc
CO_Undet	equ	4
; display bitmap over text in bitmap button
CO_BMVert	equ	8
;end dialog on control pick (buttons)
CO_EndDlg	equ	16
; zero values not allowed
CO_NoZero	equ	32
			  
;		Validation callback flags

VCF_INVALID	equ	1		;data is invalid
VCF_ENDDIALOG	equ	2		;dialog should terminate
VCF_DBLCLICK	equ	4		;item has been double clicked

;		Combo Box callback functionality flags passed on esi
; callback, eax:CBFlags, ebx:ctl ID. esi:fcf. on the return, eax:err code

FCF_EDEnd	equ	16		;calling from edit updated
FCF_OnKey	equ	17		;calling from key pressed
FCF_KF		equ	18		;calling from kill focus
FCF_SC          equ     19              ;calling from sel change

;	===============================================================
;	Control IDs: Each control has an ID assigned in the
;		resource file.
;	===============================================================
;
;	Programmer defined ID's must be  100, < 256.

;	These IDs are pre-defined in win32equ.inc:
;
;		IDOK
;		IDCANCEL
;		IDABORT
;		IDRETRY
;		IDIGNORE
;		IDYES
;		IDNO
;		IDCLOSE
;		IDHELP
;
;	ID = -1 means static control (text labels etc.)


;	===============================================================
;	Structures
;	===============================================================

PSData			struct
lpCaption		dword	0	;caption on PSheet
nPages			dword	1	;# of pages
nStartPage		dword	0	;start page #
Options			dword	0	;options for PSheet
hwndPS			dword	0	;hwnd of PSheet window
PSData			ends

PSPageData		struct
chain			dword	0	;offset of control data
Options			dword	0	;dialog box options
HlpCntxt		dword	0	;Help context number
InitCF			dword	0	;WM_INITDIALOG callback
EndCF			dword	0	;WM_DESTROY callback
HlpFile			dword	0	;optional custom help file

; above is same as SDlg struct.

lpRes			dword	0	;resource dlg name for the page
lpszTab			dword	0	;title(tab) of the page
pPSN_CB			dword	0	;callback for page notifications
hwndPSP			dword	0	;hwnd for the dlg
pNxtPage		dword	0	;pointer to next page
PSPageData		ends

;	===============================================================
;
;	Dialog box header macro
;
;	Parameters:
;
;		Rsc		Resource name
;
;		Opts		Dialog box option flags
;					Supported: None
;
;		Hlp		Help context number (0=contents pg)
;
;		InitCF		Callback (ENTRY/EXIT)
;				Dialog is being initialized.
;				(message: WM_INITDIALOG)
;
;		EndCF		Callback (ENTRY/EXIT)
;				Dialog is about to close.
;				Entry:	ax=button id (e.g. IDOK)
;				Return: ax=0 to allow close,
;					ax=1 to stop close.
;				(message: WM_DESTROY)
;		HlpF		optional custom help file
;	---------------------------------------------------------------

DLG		macro	Rsc,Opts,Hlp,InitCF,EndCF,HlpF
		local	fin
		SDlg	<fin,Opts,Hlp,InitCF,EndCF,HlpF>
		db	Rsc,0
fin		label	byte
		endm

;	---------------------------------------------------------------
;	ENDDLG - Dialog control list termination macro
;	---------------------------------------------------------------

ENDDLG		macro
		dw	0
		endm

;	---------------------------------------------------------------
;	Dialog edit control macro
;
;	Parameters:
;
;		Id		Control ID 
;
;		Options 	Edit options. Supported:
;					CO_CBOnKey,CO_NoSel,CO_NoZero
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;				plus Format data type codes. Supported:
;					T_Real4,T_Dist,T_Brng,T_AngW
;
;		Width		Max character count user can
;					type into the control
;
;		VData		Pointer to the data to be modified
;
;		ValidCF 	Callback (ENTRY/EXIT)
;				Item is losing input focus.
;				Validate or change data.
;				Entry:	esi -> data
;					bx=item id
;					eax=flags (VCF_INVALID, etc.) 
;				Exit:	eax=flags (VCF_INVALID, VCF_ENDDIALOG)
;
;	Notes:	1.	To right justify numbers in an edit control,
;			set both MULTILINE and RIGHT JUSTIFY on in the
;			dialog box editor
;	---------------------------------------------------------------

EDCTL		macro	Id,Options,Flags,Wdth,VData,ValidCF
		DCtrl	<CT_EDIT,Id,Flags,Options,Wdth,0,0,\
			VData,0,ValidCF>
		endm

;	---------------------------------------------------------------
;	Dialog edit control with spin ctrl macro
;
;	Parameters:
;
;		Id		Control ID 
;
;		Options 	Edit options. Supported:
;					CO_CBOnKey,CO_NoSel
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;				plus Format data type codes. Supported:
;					T_Real4,T_Dist,T_Brng,T_AngW
;
;		Width		Max character count user can
;					type into the control
;
;		VData		Pointer to the data to be modified
;		
;		MaxVal		Max value of Spin Ctrl
;		
;		MinVal		Min value of Spin Ctrl
;
;		ValidCF 	Callback (ENTRY/EXIT)
;				Item is losing input focus.
;				Validate or change data.
;				Entry:	esi -> data
;					bx=item id
;					eax=flags (VCF_INVALID, etc.)
;				Exit:	eax=flags (VCF_INVALID, VCF_ENDDIALOG)
;
;	Notes:	1.	To right justify numbers in an edit control,
;			set both MULTILINE and RIGHT JUSTIFY on in the
;			dialog box editor
;	---------------------------------------------------------------

EUDCTL		macro	Id,Options,Flags,Wdth,MaxVal,MinVal,VData,ValidCF
		DCtrl	<CT_EDITUD,Id,Flags,Options,Wdth,MaxVal,MinVal,\
			VData,0,ValidCF>
		endm

;	---------------------------------------------------------------
;	Dialog combo box control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Combo box options. Supported:
;					None
;
;		Flags		Format data type codes. Supported:
;					None
;
;		VData		Pointer to a word indicating
;					position in combo box of
;					currently selected string. 
;
;		LData		Pointer to list of strings to display
;					(You can point to a null string
;					and build the list at runtime
;					with AddCmbStr)
;
;		ValidCF 	Callback (ENTRY/EXIT)
;				Item is losing input focus.
;				Validate or change data.
;				Entry:	esi -> data
;					bx=item id
;					eax=flags (see callback flags)
;					    (0 = data valid)
;					esi=FCF flags (FCF_SC = picked)
;						      (FCF_KF = focus chg)
;				Exit:	eax=flags
;					(Only VCF_INVALID or VCF_ENDDIALOG
;					will be respected)
;
;		DrawCF		Callback (ENTRY/EXIT)
;				Item needs to be drawn or measured
;				Entry:	ax=0 if requesting item draw
;					    then ES:di->DRAWITEMSTRUCT
;					ax=1 if requesting list item
;					    measure (combo and lists only)
;					ax=2 if requesting edit box
;					    measure (combo box only)
;				Exit:	Measure values are returned in ax.
;
;	Notes:	1.	Currently, all combo boxes must be of
;			sub-type CBS_DROPDOWNLIST
;	---------------------------------------------------------------

CMBCTL		macro	Id,Options,Flags,VData,VList,ValidCF,DrawCF
		DCtrl	<CT_CMB,Id,Flags,Options,0,0,0,VData,\
			VList,ValidCF,DrawCF>
		endm

;	---------------------------------------------------------------
;	Dialog list box control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	List options. Supported:
;					None
;
;		Flags		Format data type codes. Supported:
;					None
;
;		VData		Pointer to a word indicating
;					position in list of
;					currently selected string. 
;
;		LData		Pointer to list of strings to display
;					(You can point to a null string
;					and build the list at runtime
;					with AddLstStr)
;
;		ValidCF 	Callback (ENTRY/EXIT)
;				Item is losing input focus.
;				Validate or change data.
;				Entry:	esi -> data
;					bx=item id
;					eax=flags (see callback flags)
;					    (0 = data valid)
;					esi=FCF flags (FCF_SC = picked)
;						      (FCF_KF = focus chg)
;				Exit:	eax=flags
;					(Only VCF_INVALID or VCF_ENDDIALOG
;					will be respected)
;
;		DrawCF		Callback (ENTRY/EXIT)
;				Item needs to be drawn or measured
;				Entry:	ax=0 if requesting item draw
;					    then ES:di->DRAWITEMSTRUCT
;					ax=1 if requesting list item
;					    measure (combo and lists only)
;					ax=2 if requesting edit box
;					    measure (combo box only)
;				Exit:	Measure values are returned in ax.

;	Notes:	1.	Set NOTIFY off in the dialog box editor unless
;			you want ValidCF to be called every time the
;			cursor bar is moved.
;	---------------------------------------------------------------

LSTCTL		macro	Id,Options,Flags,VData,VList,ValidCF,DrawCF
		DCtrl	<CT_LST,Id,Flags,Options,0,0,0,VData,\
			VList,ValidCF,DrawCF>
		endm

;	---------------------------------------------------------------
;	Dialog check box control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Check box options. Supported:
;					None
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;
;		VData		Pointer to the data to be modified
;
;		Mask		Bit mask for destination
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	eax=flags
;					(Only VCF_ENDDIALOG will be respected)
;	---------------------------------------------------------------

CHKCTL		macro	Id,Options,Flags,VData,Mask,CmdCF
		DCtrl	<CT_CHK,Id,Flags,Options,0,0,0,\
			VData,Mask,CmdCF>
		endm

;	---------------------------------------------------------------
;	Dialog Color pick box control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Color pick box options. Supported:
;					None
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;
;		VData		Pointer to the color data to be modified
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	eax=flags
;					(Only VCF_ENDDIALOG will be respected)
;	---------------------------------------------------------------

CLRCTL		macro	Id,Options,Flags,VData,CmdCF
		DCtrl	<CT_COLORPK,Id,Flags,Options,0,0,0,\
			VData,0,CmdCF>
		endm

;	---------------------------------------------------------------
;	Pattern Edit control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Pattern edit options. Supported:
;					None
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;
;		VData		Pointer to the 8x8 pattern to be modified
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	eax=flags
;					(Only VCF_ENDDIALOG will be respected)
;	---------------------------------------------------------------

PEDCTL		macro	Id,Options,Flags,VData,CmdCF
		DCtrl	<CT_PATED,Id,Flags,Options,0,0,0,\
			VData,0,CmdCF>
		endm

;	---------------------------------------------------------------
;	DWord Pattern Edit control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Pattern edit options. Supported:
;					None
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;
;		VData		ptr-> 32-bit pattern to be modified
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	eax=flags
;					(Only VCF_ENDDIALOG will be respected)
;	---------------------------------------------------------------

PEDCTLD		macro	Id,Options,Flags,VData,CmdCF
		DCtrl	<CT_PATED32,Id,Flags,Options,0,0,0,\
			VData,0,CmdCF>
		endm

;	---------------------------------------------------------------
;	Dialog button control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Button options. Supported:
;					CO_EndDlg end dialog when picked
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	eax=1 to close dialog
;
;		DrawCF		Callback (ENTRY/EXIT)
;				Item needs to be drawn or measured
;				Entry:	eax=0 if requesting item draw
;					    then EDI->DRAWITEMSTRUCT
;					eax=1 if requesting list item
;					    measure (combo and lists only)
;					eax=2 if requesting edit box
;					    measure (combo box only)
;				Exit:	Measure values are returned in eax.
;	---------------------------------------------------------------

BTNCTL		macro	Id,Options,Flags,CmdCF,DrawCF
		DCtrl	<CT_BTN,Id,Flags,Options,0,0,0,\
			0,0,CmdCF,DrawCF>
		endm

;	---------------------------------------------------------------
;	Dialog radio button control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Radio button options. Supported:
;					None
;
;		Flags		Data address codes FT_Ptr or FT_EBX
;				FT_UDec1 can be used to spec 1-byte data
;				else, dword data assumed.
;
;		VData		Pointer to the data to be modified
;
;		RetCode 	Data returned when this button selected
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	ax=1 to close dialog
;	---------------------------------------------------------------

RBCTL		macro	Id,Options,Flags,VData,RetCode,CmdCF
		DCtrl	<CT_RB,Id,Flags,Options,0,0,0,\
			VData,RetCode,CmdCF>
		endm

;	---------------------------------------------------------------
;	Dialog bitmap button control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Button options. Supported:
;					None
;
;		CmdCF		Callback (ENTRY/EXIT)
;				Item has been pressed/activated
;				Entry:	bx=item id
;				Exit:	ax=1 to close dialog
;
;	Note:	The button must be declared owner draw in the resource
;	---------------------------------------------------------------

BMCTL		macro	Id,Options,Flags,hBitmap,CmdCF
		DCtrl	<CT_BM,Id,Flags,Options,0,0,0,\
			hBitmap,0,CmdCF,0>
		endm

;	---------------------------------------------------------------
;	Dialog progress bar control macro
;
;	Parameters:
;
;		Id		Control Id. 
;
;		Options 	Button options. Supported:
;					None
;
;	---------------------------------------------------------------

PBCTL		macro	Id,Options,Flags
		DCtrl	<CT_PB,Id,Flags,Options,0,0,0,\
			0,0,0,0>
		endm

;	===============================================================
;	Property Sheets
;	===============================================================
;	The property sheet size is determined by the size of the 1st
;	page dialog resource template.
;	---------------------------------------------------------------
;	PSHEET - PropSheet Header macro
;
;	Parameters:
;
;		caption		Prop sheet title text adrs/rscid
;
;		npages		Number of pages
;
;		start page	Index of page to display on start (0..n-1)
;
;		Options		Currently support NoApplyBtn 
;
;		pCB		Callback when APPLY btn pressed 
;				without options set NoApply
;
;	---------------------------------------------------------------
PSHEET		macro	caption,npages,startpage,option,CB
		PSData	<caption,npages,startpage,option,CB>
		endm

;	---------------------------------------------------------------
;	PSPAGE - PropSheet page data macro
;
;	Parameters:
;
;		res		Resource template name for
;				the page dialog
;
;		caption 	Tab caption on the page
;
;		Opts		Options, currently set 0
;
;		Hlp		help #
;
;		InitCB		Callback when initialize 
;
;		EndCB		Callback when closing
;
;		FocusCB		Callback for page notification
;				(currently called on PSN_APPLY 
;				and PSN_SETACTIVE)
;				Entry: edi = notification (PSN_*)
;
;		HlpF		help file
;	---------------------------------------------------------------

PSPAGE		macro	res,caption,Opts,Hlp,InitCB,EndCB,NotifyCB,HlpF
		local	fin, resname
		PSPageData <fin,Opts,Hlp,InitCB,EndCB,HlpF,\
		resname,caption,NotifyCB>
resname		db	res,0
fin		label	byte
		endm

;	===============================================================
;	Special purpose, predefined dialogs
;	===============================================================

;	---------------------------------------------------------------
;	TDLG packet for SVC TEdit (Text-edit)
;	---------------------------------------------------------------

TDLG		struc
TxtAdr		DWORD	0		;->Text to edit
MaxChar 	DWORD	0		;max bytes
Flags		DWORD	0		;see below
TtlAdr		DWORD	0		;->title string (0="Edit Text")
HelpID		DWORD	0		;help context # (0=contents pg)
HelpFile	DWORD	0		;->help file name (0=ours)
TDLG		ends

PSH_NOAPPLYNOW		equ	0080h

PSM_SETCURSEL		equ	(WM_USER + 101)
PSM_REMOVEPAGE		equ	(WM_USER + 102)
PSM_ADDPAGE		equ	(WM_USER + 103)
PSM_CHANGED		equ	(WM_USER + 104)
PSM_QUERYSIBLINGS	equ	(WM_USER + 108)
PSM_UNCHANGED		equ	(WM_USER + 109)
PSM_APPLY		equ	(WM_USER + 110)
PSM_SETTITLEA		equ	(WM_USER + 111)
PSM_SETTITLE		equ	PSM_SETTITLEA

NoApplyBtn	equ	0080h		;flag for PSheet Options

