;	===============================================================
;	CtrlObj.CPY - Control Object Base Class
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 14-July-1999
;	===============================================================

GetPWinO	proto	stdcall,hCtrl:dword
GetPFree	proto	stdcall,hCtrl:dword
CreateCtrl	proto	stdcall,hPWinO:dword,hPCtrl:dword,\
			take:dword,tsize:dword,\
			frame:dword,flags:dword

Ctrl		struc
ppCtrlVTbl	dword	0		;methods VTable
hPWinO		dword	0		;parent window Win object
hPCtrl		dword	0		;parent control object
Loc		RECT	<>		;location rectangle
Free		RECT	<>		;unallocated rectangle
take		dword	0		;take flags
tsize		dword	0		;take size
tsizea		dword	0		;apportioned take
frame		dword	0		;frame style
flags		dword	0		;general flags
CType		word	0		;control type
Stat		word	1		;1=control visible
CName		db	64 dup (0)	;control name
;
pTTip		dword	0		;tooltip text for control
LBProc		dword	0		;call on left button click
RBProc		dword	0		;call on right button click
Ctrl		ends

;	Values for Ctrl.frame:

CI_Frame_Up	equ	0	;button is up
CI_Frame_Down	equ	1	;button is down
CI_Frame_None	equ	2	;button is not framed
CI_Frame_Flat	equ	3	;flat black border, grey interior

;	===============================================================
;	Ctrl Object Method Equates
;	===============================================================

CIDelete	equ	0		;delete the control
CIUpdate	equ	1		;update ctrl to screen
CIResize	equ	2		;move/resize the control
CIDraw		equ	3		;draw the control to BkImage
CIMouse		equ	4		;process mouse event

;	===============================================================
;	Color Bar Object Method Equates
;	===============================================================

CBAsk		equ	5		;ask selected color
CBSet		equ	6		;set selected color
CBSetIndex	equ	7		;set color index values
CBGetIndex	equ	8		;get color index value

;	===============================================================
;	Icon Bar Object Method Equates
;	===============================================================

IBGetBaseID	equ	5		;get base icon id #
IBSetScript	equ	6		;set script text
IBGetScript	equ	7		;get script text
IBGetString	equ	8		;get icnname,script text

;	===============================================================
;	Ctrl.flags values:
;	===============================================================

TK_NOTB		equ	40000000h	;can't be horizontal
TK_NOLR		equ	80000000h	;can't be vertical

;	===============================================================
