////////////////// CsrMgr.H - Cursor Support - FastCAD-7 /////////////////
//
//	Written by Mike Riddle 4-Nov-1999
//	(C)1999 Evolution Computing
//	All rights reserved
//
//////////////////////////////////////////////////////////////////////////

#ifndef _CSRMGR_H_
#define _CSRMGR_H_

void _stdcall SetCursorOrg2(double x, double y);
void _stdcall SetCursorOrg3(double x, double y, double z);
void _stdcall SetCursorType(DWORD CType);
void _stdcall UpdateCursor(void *hDWin, double RealX, double RealY, double RealZ);
void _stdcall UpdateMWC(DWORD DigX, DWORD DigY);
void _stdcall ProcCsrSnap(DWORD Flags);
void _stdcall ProcCsrSnapEx(DWORD pPt3, DWORD Flags);
void _stdcall ForceCsrSnap(DWORD Flags);
void _stdcall RemoveCursor(void);
void _stdcall SetMousePos(DWORD hWin, DWORD X, DWORD Y);
void _stdcall XHReqCsr(DWORD hDW);
void _stdcall XHReqCsr3(DWORD hDW);

//	Predefined cursor types

#define	RDC_None	   0
#define	RDC_Arrow	   1
#define RDC_Wait	   2
#define RDC_Thumb	   3
#define	RDC_RXH2	   4
#define	RDC_RBand2	 5
#define	RDC_RWin2	   6
#define	RDC_RPick2	 7
#define	RDC_RXH3	   8
#define	RDC_RBand3	 9
#define	RDC_RWin3	  10
#define	RDC_RPick3	11
#define	RDC_MWXH	  12
#define	RDC_MWWin	  13
#define	RDC_MWRect	14
#define	RDC_MWGrow	15

//	Data structure for RDC_MWRect (window move cursor)

void _stdcall SetMWRectCsr(DWORD pCDef);

typedef struct
{
	RECT	ORect;		
	RECT	NRect;		
	POINT	OPt;		
	POINT	NPt;		
	DWORD	DCsr;			// grow drag cursor
	DWORD	DCode;		// grow drag code
}MWRCsr;



#endif
