///////////////// CXPTEST.CPP - FastCAD-7 C-language Test XP //////////
//
//	Written by Mike Riddle 11-4-1999
//	(C)1999 Evolution Computing
//	All rights reserved
//
///////////////////////////////////////////////////////////////////////

#include <windows.h>
#include <xp7.h>

#define XPID 0xF000

void XPCALL About(void);
void XPCALL CTEST1(void);
void XPCALL CTEST2(void);

char CList[]="CTEST1\0CTEST2\0\0";
PCMDPROC PList[]={About,CTEST1,CTEST2};

XP MyXP = 
   { 0,0,"C Test XP - V7",CList,PList,0 };

/////////////  DllMain - XP initialization & Unload code //////////////

BOOL WINAPI DllMain (HINSTANCE hDLL, DWORD dwReason, LPVOID lpReserved)
{ switch (dwReason)
	{ case DLL_PROCESS_ATTACH:
		{
		MyXP.ModHdl=hDLL;
		XPRegister(&MyXP);
		break;
		}
	  case DLL_PROCESS_DETACH:
		{
		XPUnRegister(&MyXP);
		break;
		}
	}
return TRUE;
}
////////////////////// CXPTEST About information ////////////////////

void XPCALL About (void)
{
	FormSt("CXPTEST commands:\n\n"
	   "\tCTEST1 - Create line entities\n"
	   "\tCTEST2 - Move entities\n\0"
	   ,RSC(FV_NONE),"About CXPTest\0",RSC(FD_MsgBox+FD_BTitle));
}

/////////////////////////// CTEST1 XP command //////////////////////////

LINE2 BuildL = { sizeof(LINE2), ET_LINE2, 0, 0, 0, 0, 0, 0, 1, 0.0, 0, 0,
					 0.0, 0.0, 1.0, 1.0 };

FORMST(lpszP1,"1st point:\0")
FORMST(lpszNext,"Next point:\0")

IDList* hDwgDL;
pENTREC pEntRec;

//	-----------------------------------------------------------------

void XPCALL CTEST1B (int Result);
void XPCALL CTEST1C (int Result);

void XPCALL CTEST1 (void)
{
	ReqData(RD_2dC8,&BuildL.Geo.p1,"1st point:\0",
		RSC(RDC_RXH2),CTEST1B,RDF_NONE,IDH_LINE2);
}

void XPCALL CTEST1B (int Result)
{
	if (Result != RD_OK) { CmdEnd(); return; }
	hDwgDL=GetWorkDL();
	ClearSelect();		// for select by prior
	hDwgDL->DLMarkUndo();
	SetCursorOrg2(BuildL.Geo.p1.x,BuildL.Geo.p1.y);
	ReqData(RD_2dC8,&BuildL.Geo.p2,"Next point:\0",
		RSC(RDC_RBand2),CTEST1C,RDF_NONE,IDH_LINE2);
}

void XPCALL CTEST1C (int Result)
{
	if (Result != RD_OK) { CmdEnd(); return; }

//	Append the entity to the database and draw it

	pEntRec=hDwgDL->DLApnd(&BuildL);
	SetCStuff(pEntRec);
	hDwgDL->DLSelect(pEntRec);
	EDraw(NULL,pEntRec);
	ShowChanges();

//	Setup for chained line creation

	BuildL.Geo.p1.x=BuildL.Geo.p2.x;
	BuildL.Geo.p1.y=BuildL.Geo.p2.y;
	SetCursorOrg2(BuildL.Geo.p1.x,BuildL.Geo.p1.y);
	ReqData(RD_2dC8,&BuildL.Geo.p2,"Next point:\0",
		RSC(RDC_RBand2),CTEST1C,RDF_NONE,IDH_LINE2);
}

/////////////////////////// CTEST2 XP command //////////////////////////

GPNT3	MoveFrom,MoveTo;
TMat	MoveTM;

//	-----------------------------------------------------------------

void XPCALL CTEST2B (int Result);
void XPCALL CTEST2C (int Result);
void XPCALL CTEST2D (int Result);

void XPCALL CTEST2 (void)
{
	ReqData(RD_Pick,NULL,RSC(RSC_Select),
		RSC(RDC_Arrow),CTEST2B,RDF_NONE,IDH_SELECT);
}

void XPCALL CTEST2B (int Result)
{
	if (Result != RD_OK) { CmdEnd(); return; }
	hDwgDL=GetWorkDL();
	ReqData(RD_3dC8,&MoveFrom,RSC(RSC_MoveFrom),
		RSC(RDC_RXH3),CTEST2C,RDF_NONE,IDH_MOVE);
}

void XPCALL CTEST2C (int Result)
{
	if (Result != RD_OK) { CmdEnd(); return; }
	hDwgDL=GetWorkDL();
	hDwgDL->DLMarkUndo();
	SetCursorOrg3(MoveFrom.x,MoveFrom.y,MoveFrom.z);
	ReqData(RD_3dC8,&MoveTo,RSC(RSC_MoveTo),
		RSC(RDC_RBand3),CTEST2D,RDF_NONE,IDH_MOVE);
}

int XPCALL CTEST2Rec (IDList* hDL,pENTREC pEntRec,int Parm1, int Parm2)
{
	pENTREC pNew;
	pNew=hDwgDL->DLClone(pEntRec);
	ETran(pNew,&MoveTM);
	EErase(NULL,pEntRec);
	EDraw(NULL,pNew);
	return(0);
}

void XPCALL CTEST2D (int Result)
{
	if (Result != RD_OK) { CmdEnd(); return; }
	hDwgDL=GetWorkDL();

	CTMPSH();
	CTMI3();
	CTMT3(MoveTo.x-MoveFrom.x,MoveTo.y-MoveFrom.y,MoveTo.z-MoveFrom.z);
	STCTM(&MoveTM);
	CTMPOP();

	hDwgDL->DLScan(&CTEST2Rec,DLS_Edit,0,0);

	ShowChanges();
	CmdEnd();
}

