//	===================================================================
//	CRender.h - General Render Object Interface
//
//	Written by Mike Riddle 14-Oct-2000
//	(C) 2000 Evolution Computing
//	All rights reserved
//	===================================================================

interface CRender
{
	virtual void XPCALL RenderDelete(void)=0;
	virtual HANDLE XPCALL CreateRendObj(int ScrnRes,
		int* pColorTable,int nVShift)=0;
	virtual BOOL XPCALL RenderDrawDW(HANDLE hDWIN,
		SCANCALLBACK pEntCB,void* pLightsIB)=0;
	virtual BOOL XPCALL RenderLine2(GLINE2* pGLine2)=0;
	virtual BOOL XPCALL RenderLine3(GLINE3* pGLine3)=0;
	virtual BOOL XPCALL RenderPath2(GPATH2* pGPath2)=0;
	virtual BOOL XPCALL RenderPath3(GPATH3* pGPath3)=0;
	virtual BOOL XPCALL RenderPoly2(GPATH2* pGPoly2)=0;
	virtual BOOL XPCALL RenderPoly3(HANDLE hDWin,GPATH3* pGPoly3)=0;
	virtual BOOL XPCALL RenderSphere(GSPH3* pGSphere)=0;
	virtual BOOL XPCALL RenderMPoly3Bgn(void)=0;
	virtual BOOL XPCALL RenderMPoly3End(void)=0;
	virtual BOOL XPCALL RenderProperties(int ColorV,int nMatrl)=0;
	virtual BOOL XPCALL RenderPatch(void* hDWin,GPATH3* pGPoly3)=0;
	virtual BOOL XPCALL RenderTStripS(void)=0;
	virtual BOOL XPCALL RenderTStrip(GPNT3* pP1, GPNT3* pDV1,
								   GPNT3* pP2, GPNT3* pDV2)=0;
	virtual BOOL XPCALL RenderTStripE(void)=0;

	virtual BOOL XPCALL RenderMPoly3LS(void)=0;
	virtual BOOL XPCALL RenderMPoly3LN(GPNT3* pNode)=0;
	virtual BOOL XPCALL RenderMPoly3LE(void)=0;
	virtual	int XPCALL RenderSpecify(int nCode,int* pValue)=0;

	virtual BOOL XPCALL RenderPrintDW(HANDLE hDWIN,
		SCANCALLBACK pEntCB,void* pLightsIB)=0;
	virtual BOOL XPCALL RenderFileDW(HANDLE hDWIN,
		int nType,char* pFName,SCANCALLBACK pEntCB,void* pLightsIBlk)=0;
	virtual BOOL XPCALL RenderCyl(GCYL3* pGCyl)=0;
	virtual BOOL XPCALL RenderDisc(GDISC3* pGDisc)=0;
};

HANDLE XPCALL CreateRendObjFactory(LPVOID hObj,int ScrnRes,
									int* pColorTable,int nVShift);

void XPCALL SpecRendObj(HANDLE hRend);

//	===================================================================
//	Helper Functions for Rendering
//	===================================================================

void XPCALL DWScanLine(HANDLE hDWin, int nLine, char* pBytes);
void XPCALL DWRendStart(HANDLE hDWin);
void XPCALL DWRendEnd(HANDLE hDWin);
void XPCALL DWRendVector(HANDLE hDWin,int x1, int y1, int x2, int y2);
float XPCALL MaterialScale(int nMaterial);

//	===================================================================

#define RENDS_RMODE		0
#define RENDS_ASK_PRINT	1
#define RENDS_ASK_FILE	2
#define	RENDS_ID		3

#define	RENDS_ID_OGL	0
#define	RENDS_ID_LW		1

#define	RENDS_FILE_BMP	0
#define	RENDS_FILE_JPG	1
#define	RENDS_FILE_TGA	2
#define	RENDS_FILE_TIF	3
#define	RENDS_FILE_PNG	4
#define	RENDS_FILE_SVG	5

//	===================================================================
