// 	===============================================================
// 	BkImage.CPY - Backup Image Object Method Equates
// 	===============================================================
// 	Copyright 1999 Evolution Computing
// 	All rights reserved
// 	Written by Mike Riddle 8-July-1999
// 	===============================================================
// 	BkImage object structure
// 	===============================================================

#ifndef _BKIMAGE_H_
#define _BKIMAGE_H_

#define BKCLIPSTACK 5

typedef struct
{
	DWORD	ppBkIVTbl;		// ->-> methods VTable
	DWORD	hdc;					// backup image target hDC
	DWORD	TargWid;			// target width in pixels
	DWORD	TargHgt;			// target height in pixels
	DWORD	RowSize;			// # bytes per row
	DWORD	BkMode;				// current BI_Sel_XXX mode
	DWORD	OfstX;				// upper left pixel coordinate
	DWORD	OfstY;		
	DWORD	XORMode;			// 1 = XOR direct draw mode
	DWORD	hClipCsr;			// cursor draw clip region for hdc
	DWORD	hClipRgn;			// current draw clip region
	DWORD ClipStack[BKCLIPSTACK];	// clip rgn stack
	DWORD	pZBuf;				// adrs of Z-buffer
	DWORD	BkType;				// type of BkImage
 											// 0 = DIBSection
 											// 1 = DirectDraw
 											// 2 = Windows API
 
	DWORD	hSection;			// handle of DIB Section
	DWORD	hOldBmp;			// DIBS BMP to reselect before delete
 
	DWORD	UseDC;				// current dc to draw direct
	DWORD	UseBits;			// pBits to use to draw
	DWORD	UseSurf;			// current DD Surface
	DWORD	UseRC;				// OpenGL Render Context
 
	DWORD	PThickU;			// pen thickness in units

	DWORD	DrawColor;		// draw bright blue
	DWORD	FillColor;		// fill bright blue
	DWORD	ClearColor;		// clear to dk red
	DWORD	FillBrush;		// adrs of 8x8 brush pattern
 
// 	the BITMAPINFOHEADER structure for a DIB section
 
	DWORD	biSize;	
	DWORD	biWidth;		
	DWORD	biHeight;		
	WORD	biPlanes;		
	WORD	biBitCount;		
	DWORD	biCompression;		
	DWORD	biSizeImage;		
	DWORD	biXPelsPerMeter;		
	DWORD	biYPelsPerMeter;		
	DWORD	biClrUsed;		
	DWORD	biClrImportant;
}BKIMAGE;

#define BKTYPE_DIB	0
#define BKTYPE_DD		1
#define BKTYPE_API	2

// 	===============================================================
// 	BkImage Method Equates
// 	===============================================================

void _stdcall CreateBkImage(DWORD hdc, DWORD wid, DWORD hgt, DWORD OfstX, DWORD OfstY);
void _stdcall CreateDDImage(DWORD hdc, DWORD wid, DWORD hgt, DWORD OfstX, DWORD OfstY);
void _stdcall CreateBkImageW(DWORD hdc, DWORD wid, DWORD hgt, DWORD OfstX, DWORD OfstY);

#define BIDelete				0
#define BIUpdate				1
#define BISelect				2
 
#define BIDrawColor			3
#define BIFillColor			4
#define BIClearColor		5
#define BIClear					6
#define BILine					7
#define BIRect					8
#define BIFRect					9
#define BIDrawIcon		 10
#define BIDrawFrame		 11
#define BIDrawText		 12
#define BIDrawBitmap	 13
#define BIDrawPoint		 14
#define BIDrawCircle	 15
#define BIHzSFill			 16
#define BIFillBrush		 17
#define BIHzBFill			 18
#define BIXfr					 19
#define BIClip				 20
#define BIZClear			 21
#define BILine3				 22
#define BIHzSFill3		 23
#define BIFrameRect		 24	// COBJ hBkImage,Code,pRect
#define BIMPoly				 25	// COBJ hBkImage,pPatrn,nPolys,pSegL,pNodeL
#define BIDrawGText		 26	// COBJ hBkImage,pText,X,Y,hFont
#define BIPoint				 27	// COBJ hBkImage,X,Y
#define BISetPThick		 28	// COBJ hBkImage,PThick(in mm)
#define BIBmpFill		   29	// COBJ hBkImage,hBmp,mode,pDRect,pSRect
#define BIMPolyClip		 30	// COBJ hBkImage,nPolys,pSegL,pNodeL
#define BIScanLine		 31	// COBJ hBkImage,nLine,pBytes

#define BI_Clip_None		0
#define BI_Clip_Set			1
#define BI_Clip_Exclude	2

#define BI_Sel_XOR			4	// direct to screen XOR
#define BI_Sel_BkImage	8	// draw to bkimage

#define BI_Frame_Up			0	// button is up
#define BI_Frame_Down		1	// button is down
 													// (callers of Set/Get status needs this = 1)
#define BI_Frame_None		2	// button is not framed

#define BI_Text_Left		0	// left justified text
#define BI_Text_Center	1	// center justified text

typedef struct
{
	DWORD	X1;		
	DWORD	Y1;		
	DWORD	X2;		
	DWORD	Y2;		
}LINE;

typedef struct
{
	DWORD	X;		
	DWORD	Y;		
	DWORD	R;		
}CIRCLE;

typedef struct
{
	DWORD	X1;		
	float	Z1;		
	DWORD	X2;
	float	Z2;		
}SPAN3;

#endif