;	===============================================================
;	BkImage.CPY - Backup Image Object Method Equates
;	===============================================================
;	Copyright 1999 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 8-July-1999
;	===============================================================
;	BkImage object structure
;	===============================================================
BKCLIPSTACK	equ	5
BkImage		struc
;
ppBkIVTbl	dword	0		;->-> methods VTable
hdc		dword	0		;backup image target hDC
TargWid		dword	0		;target width in pixels
TargHgt		dword	0		;target height in pixels
RowSize		dword	0		;# bytes per row
BkMode		dword	0		;current BI_Sel_XXX mode
OfstX		dword	0		;upper left pixel coordinate
OfstY		dword	0
XORMode		dword	0		;1 = XOR direct draw mode
hClipCsr	dword	0		;cursor draw clip region for hdc
hClipRgn	dword	0		;current draw clip region
		dword	BKCLIPSTACK dup (0)	;clip rgn stack
pZBuf		dword	0		;adrs of Z-buffer
BkType		dword	0		;type of BkImage
;					;0 = DIBSection
;					;1 = DirectDraw
;					;2 = Windows API
;
hSection	dword	0		;handle of DIB Section
hOldBmp		dword	0		;DIBS BMP to reselect before delete
;
UseDC		dword	0		;current dc to draw direct
UseBits		dword	0		;pBits to use to draw
UseSurf		dword	0		;current DD Surface
UseRC		dword	0		;OpenGL Render Context
;
PThickU		dword	0		;pen thickness in units
;
DrawColor	dword	000000FFh	;draw bright blue
FillColor	dword	000000FFh	;fill bright blue
ClearColor	dword	00440000h	;clear to dk red
FillBrush	dword	0		;adrs of 8x8 brush pattern
;
;	the BITMAPINFOHEADER structure for a DIB section
;
biSize			dword	sizeof(BITMAPINFOHEADER)
biWidth			dword	?
biHeight		dword	?
biPlanes		word	1
biBitCount		word	24
biCompression		dword	BI_RGB
biSizeImage		dword	0
biXPelsPerMeter		dword	0
biYPelsPerMeter		dword	0
biClrUsed		dword	0
biClrImportant		dword	0
;
BkImage		ends

BKTYPE_DIB	equ	0
;;BKTYPE_DD	equ	1
BKTYPE_API	equ	2

;	===============================================================
;	BkImage Method Equates
;	===============================================================

CreateBkImage	proto	stdcall,hdc:dword,wid:dword,hgt:dword,\
			OfstX:dword,OfstY:dword

CreateDDImage	proto	stdcall,hdc:dword,wid:dword,hgt:dword,\
			OfstX:dword,OfstY:dword

CreateBkImageW	proto	stdcall,hdc:dword,wid:dword,hgt:dword,\
			OfstX:dword,OfstY:dword

BIDelete	equ	0
BIUpdate	equ	1
BISelect	equ	2
;
BIDrawColor	equ	3
BIFillColor	equ	4
BIClearColor	equ	5
BIClear		equ	6
BILine		equ	7
BIRect		equ	8
BIFRect		equ	9
BIDrawIcon	equ	10
BIDrawFrame	equ	11
BIDrawText	equ	12
BIDrawBitmap	equ	13
BIDrawPoint	equ	14
BIDrawCircle	equ	15
BIHzSFill	equ	16
BIFillBrush	equ	17
BIHzBFill	equ	18
BIXfr		equ	19
BIClip		equ	20
BIZClear	equ	21
BILine3		equ	22
BIHzSFill3	equ	23
BIFrameRect	equ	24	;COBJ hBkImage,Code,pRect
BIMPoly		equ	25	;COBJ hBkImage,pPatrn,nPolys,pSegL,pNodeL
BIDrawGText	equ	26	;COBJ hBkImage,pText,X,Y,hFont
BIPoint		equ	27	;COBJ hBkImage,X,Y
BISetPThick	equ	28	;COBJ hBkImage,PThick(in mm)
BIBmpFill	equ	29	;COBJ hBkImage,hBmp,mode,pDRect,pSRect
BIMPolyClip	equ	30	;COBJ hBkImage,nPolys,pSegL,pNodeL
BIScanLine	equ	31	;COBJ hBkImage,nLine,pBytes
BIDIBFill	equ	32	;COBJ hBkImage,hDIBI,mode,pDRect

BI_Clip_None	equ	0
BI_Clip_Set	equ	1
BI_Clip_Exclude	equ	2

BI_Sel_XOR	equ	4	;direct to screen XOR
BI_Sel_BkImage	equ	8	;draw to bkimage

BI_Frame_Up	equ	0	;button is up
BI_Frame_Down	equ	1	;button is down
;				;(callers of Set/Get status needs this = 1)
BI_Frame_None	equ	2	;button is not framed

BI_Text_Left	equ	0	;left justified text
BI_Text_Center	equ	1	;center justified text

LINE		struc
X1		dword	0
Y1		dword	0
X2		dword	0
Y2		dword	0
LINE		ends

CIRCLE		struc
X		dword	0
Y		dword	0
R		dword	0
CIRCLE		ends

Span3		struc
X1		dword	0
Z1		real4	0.0
X2		dword	0
Z2		real4	0.0
Span3		ends

