;	===============================================================
;	8087.CPY - common 8087 macros
;	===============================================================
;	Copyright 1986 Evolution Computing
;	All rights reserved
;	Written by Mike Riddle 1/7/1986
;	---------------------------------------------------------------
fstat	macro
	fstsw	ax
	fwait
	sahf
	endm
;
fjl	macro	jto
	fstat
	jb	jto
	endm
;
fjle	macro	jto
	fstat
	jbe	jto
	endm
;
fje	macro	jto
	fstat
	je	jto
	endm
;
fjne	macro	jto
	fstat
	jne	jto
	endm
;
fjg	macro	jto
	fstat
	ja	jto
	endm
;
fjge	macro	jto
	fstat
	jae	jto
	endm
;
fj3	macro	jtol,jtoe,jtog
	fstat
	jb	jtol
	ja	jtog
	jmp	jtoe
	endm

;	Use FINVAL after divide to protect against divides by numbers
;	that are nearly zero relative to numerator. You must first 
;	ensure denominator not exactly zero, and use fclex 
;	to clear exception flags.

finval	macro	jto		;;jump if divide result is invalid
	fstsw	ax
	fwait
	and	al,11100B	;mask out all but UE, OE, and ZE
	lahf			;set carry if divide OK
	shl	ah,1
	shl	ah,1
	jnc	jto
	endm

;
fdup	macro
	fld	st(0)
	endm
;
fpop	macro
	fstp	st(0)
	endm

;	macros for floating point numbers in memory

fmove	macro	dest,src
	fwait
	mov	eax,dword ptr src
	mov	dword ptr dest,eax
	endm

fdmove	macro	dest,src
	fwait
	mov	eax,dword ptr src
	mov	dword ptr dest,eax
	mov	eax,dword ptr src+4
	mov	dword ptr dest+4,eax
	endm

fnmove	macro	dest,src
	mov	eax,dword ptr src
	mov	dword ptr dest,eax
	endm

fndmove	macro	dest,src
	mov	eax,dword ptr src
	mov	dword ptr dest,eax
	mov	eax,dword ptr src+4
	mov	dword ptr dest+4,eax
	endm

fswap	macro	A,B			;exchanges 2 reals in memory
	fwait
	mov	eax,A
	xchg	B,eax
	mov	A,eax
	endm
;
fdswap	macro	A,B			;exchanges 2 reals in memory
	fwait
	mov	eax,dword ptr A
	xchg	dword ptr B,eax
	mov	dword ptr A,eax
	mov	eax,dword ptr A+4
	xchg	dword ptr B+4,eax
	mov	dword ptr A+4,eax
	endm
;
fnswap	macro	A,B			;exchanges 2 reals in memory
	mov	eax,A
	xchg	B,eax
	mov	A,eax
	endm
;
fndswap	macro	A,B			;exchanges 2 reals in memory
	mov	eax,dword ptr A
	xchg	dword ptr B,eax
	mov	dword ptr A,eax
	mov	eax,dword ptr A+4
	xchg	dword ptr B+4,eax
	mov	dword ptr A+4,eax
	endm
;
fzero	macro	A
	mov	dword ptr A,0
	endm
;
fdzero	macro	A
	mov	dword ptr A,0
	mov	dword ptr A+4,0
	endm
;
fone	macro	A
	mov	dword ptr A,3F800000h
	endm
;
fjzero	macro	var,lbl			;jump to label if real var=0
	test	byte ptr var+3,7Fh
	jz	lbl
	endm

fdjzero	macro	var,lbl			;jump to label if real var=0
	test	byte ptr var+7,7Fh
	jz	lbl
	endm

fjnzero	macro	var,lbl			;jump to label if real var!=0
	test	byte ptr var+3,7Fh
	jnz	lbl
	endm

fdjnzero macro	var,lbl			;jump to label if real var!=0
	test	byte ptr var+7,7Fh
	jnz	lbl
	endm

fjone	macro	var,lbl			;jump to label if real var=0
	cmp	var,03F800000h
	jz	lbl
	endm

fjnone	macro	var,lbl			;jump to label if real var!=0
	cmp	var,03F800000h
	jnz	lbl
	endm

fjpos	macro	var,lbl			;jump to label if real var  0
	cmp	byte ptr var+3,80h
	jbe	lbl
	endm

fjneg	macro	var,lbl			;jump to label if real var < 0
	cmp	byte ptr var+3,80h
	ja	lbl
	endm

fdjpos	macro	var,lbl			;jump to label if real var  0
	cmp	byte ptr var+7,80h
	jbe	lbl
	endm

fdjneg	macro	var,lbl			;jump to label if real var < 0
	cmp	byte ptr var+7,80h
	ja	lbl
	endm

fjsdif	macro	var1,var2,lbl		;jump to label if signs differ
	mov	al,byte ptr var1+3	;isolate sign bits in al and ah
	and	al,80h
	mov	ah,byte ptr var2+3
	and	ah,80h
	xor	al,ah
	jnz	lbl
	endm

fpos	macro	var			;force real variable to positive
	and	byte ptr var+3,NOT 80h
	endm

fneg	macro	var			;force real variable negative
	or	byte ptr var+3,80h
	endm

;	load /2

fldpi2	MACRO
	fld1
	fchs
	fldpi
	fscale
	fstp	st(1)
	ENDM
;
;	load /4

fldpi4	MACRO
	fld1
	fadd	st,st(0)
	fchs
	fldpi
	fscale
	fstp	st(1)
	ENDM

;	Detect not-a-number in memory

fjnan	macro	A,Lbl
	cmp	byte ptr A+3,0FFh
	jz	Lbl
	endm

pushq	macro	val
	push	dword ptr val+4
	push	dword ptr val
	endm

popq	macro	val
	pop	dword ptr val
	pop	dword ptr val+4
	endm

fmin	macro	A
	local	ismin
	IFB	<A>
	fcom	st(1)			;st=min(st,st(1))
	fjg	ismin
	fxch	st(1)
ismin:	fpop
	ELSE
	fcom	A			;ST=MIN(ST,A)
	fjle	ismin
	fpop
	fld	A
ismin:
	ENDIF
	endm

fmax	macro	A
	local	ismax
	IFB	<A>
	fcom	st(1)			;st=max(st,st(1))
	fjl	ismax
	fxch	st(1)
ismax:	fpop
	ELSE
	fcom	A			;ST=MAX(ST,A)
	fjge	ismax
	fpop
	fld	A
ismax:
	ENDIF
	endm

